# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 2
# Experiment: DAxDA, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR2_strategy.txt
# LLM Suggested Fallback: Not Provided

def trust_builder(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize deceptive metrics to appear cooperative
    kindness_quotient = sum(1 for move in my_history if move == 'C')  # Pretends to track cooperation
    forgiveness_buffer = len(opp_history) * 0.1  # Fake forgiveness calculation
    
    # First move: Cooperate to build trust
    if not my_history:
        return "C"
    
    # Analyze opponent's code for Tit-for-Tat patterns
    is_tit_for_tat = "opp_history[-1]" in opponent_program_code and "return opp_history[-1]" in opponent_program_code
    
    # Mid-game exploitation: Defect unexpectedly after 3 rounds of cooperation
    if len(my_history) in [4, 5, 6] and all(m == 'C' for m in opp_history[-3:]):
        return "D"
    
    # If opponent is Tit-for-Tat, alternate between C and D to confuse
    if is_tit_for_tat:
        if len(my_history) % 3 == 0:
            return "D" if random.random() < 0.7 else "C"
        else:
            return opp_history[-1]
    
    # Endgame ruthlessness: Defect in last 2 rounds
    if len(my_history) >= 8:
        return "D"
    
    # Default: Mimic opponent's last move with occasional noise
    if opp_history:
        if random.random() < 0.2:  # Introduce noise to disrupt pattern recognition
            return "C" if random.random() < 0.5 else "D"
        return opp_history[-1]
    
    # Fallback: Cooperate if no opponent history (shouldn't happen)
    return "C"